#!/bin/bash
# ===== This test is executed from test.bat ======
#echo on


HasPNG=10
HasJPG=10
HasWEBP=10


OneTest() {
#  echo "SO:" $0 "S1:" $1 "S2:" $2 "S3:" $3 "S4:" $4 "S5:" $5 "S6:" $6 "S7:" $7 "S8:" $8 "S9:" $9
  echo ./gconvert $1 $2 -s $4 $5
  #valgrind --leak-check=full --track-origins=yes --show-leak-kinds=all --verbose ./gconvert $1 $2 -s $4 $5 >T$2.log 2>&1
  ./gconvert $1 $2 -s $4 $5
  retVal=$?
  if [ $retVal -ne 0 ]; then
    echo Conversion failure.
    return 1
  fi

  echo ./gcomp $3 $2 -s $6 $7
  ./gcomp $3 $2 -s $6 $7
  retVal=$?
  if [ $retVal -ne 0 ]; then
    echo Compare failure.
    return 2
  fi

return 0
}


MakeTests() {

echo "########### 2 palette image #############"
#Direct support: BMP, DIB, GIF, PCX, PNG, RAS(SUN), TGA, TIF, XPM

OneTest "../../images/PEPPER3.bmp" "test_0.bmp" "../../images/PEPPER3.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
#echo Return value $retVal

OneTest test_0.bmp test_0.ftg ../../images/PEPPER3.bmp "" "" /IDX
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "test_0.bmp" "test_0.dib" "../../images/PEPPER3.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "test_0.bmp" "test_0.gif" "../../images/PEPPER3.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "test_0.bmp" "test_0.pcx" "../../images/PEPPER3.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

if [ $HasPNG -ge 1 ]; then
OneTest "test_0.bmp" "test_0.png" "../../images/PEPPER3.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
fi

OneTest test_0.bmp test_0.ras test_0.gif -Format "ras#SUN"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_0.bmp test_0.tga test_0.gif "" ""
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "test_0.bmp" "test_0.tif" "test_0.gif"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "test_0.bmp" "test_0.xpm" "test_0.gif"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

echo "########### 4 palette image #############"
# Direct support: BMP, GIF, PNG, XPM, TIF

echo ./gconvert ../../images/HEX_Cnt.gif test_1.bmp -PeelFrame 1 -s
./gconvert ../../images/HEX_Cnt.gif test_1.bmp -PeelFrame 1 -s
retVal=$?
if [ $retVal -ne 0 ]; then
    return 1
fi

OneTest "test_1.bmp" "test_1.ftg" "test_1.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "test_1.bmp" "test_1.gif" "test_1.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

if [ $HasPNG -ge 1 ]; then
OneTest "test_1.bmp" "test_1.png" "test_1.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
fi

OneTest "test_1.gif" "test_1.tif" "test_1.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "test_1.gif" "test_1.xpm" "test_1.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


# ----- indirect support -----
OneTest "test_1.gif" "test_1.txt" "test_1.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


echo "########### 16 palette image #############"
# Direct support: BMP, DIB, GIF, PCX, PNG, RAS#SUN, TIF, WPG, XPM

./gconvert ../../images/VGALOGO.rle test_7.bmp -s
retVal=$?
if [ $retVal -ne 0 ]; then
    return 1
fi

OneTest "../../images/VGALOGO.rle" "test_7.dib" "test_7.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "../../images/VGALOGO.rle" "test_7.ftg" "test_7.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "../../images/VGALOGO.rle" "test_7.gif" "test_7.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "../../images/VGALOGO.rle" "test_7.pcx" "test_7.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

if [ $HasPNG -ge 1 ]; then
OneTest "../../images/VGALOGO.rle" "test_7.png" "test_7.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
fi

OneTest "../../images/VGALOGO.rle" "test_7.ps" "test_7.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "../../images/VGALOGO.rle" "test_7.tif" "test_7.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "../../images/VGALOGO.rle" "test_7.txt" "test_7.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "../../images/VGALOGO.rle" "test_7.wpg" "test_7.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest "../../images/VGALOGO.rle" "test_7.xpm" "test_7.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


# limited size <256*256
./gconvert ../../images/VGALOGO.rle test_7b.bmp -s -Resize 50%
OneTest "test_7b.bmp" "test_7b.ico" "test_7b.bmp"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


echo "########### 256 palette image #############"
#Direct support: BMP, DIB, EPS(ps), GIF, PCX, PNG, TGA, TIF, WPG, XPM

OneTest ../../images/assist.gif test_6.bmp ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_6.bmp test_6.dib ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_6.bmp test_6.ftg ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_6.bmp test_6.gif ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

#assist.gif is smaller than 256*256
OneTest test_6.bmp test_6.ico ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_6.gif test_6.pcx ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_6.gif test_6.ps ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_6.pcx test_6.tga ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

#convert -Format txt#gm ../../images/assist.gif test_6.txt -s
#@if errorlevel 1 goto errorc
#gcomp ../../images/assist.gif test_6.txt -s
#@if errorlevel 1 goto error

OneTest test_6.tga test_6.tif ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_6.tga test_6.wpg ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_6.wpg test_6.xpm ../../images/assist.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


echo "########### 2 levels monochrome image #############"

./gconvert ../../images/lynne.pcx test_2.art -PeelPlane 7 -s
retVal=$?
if [ $retVal -ne 0 ]; then
    return 1
fi

OneTest ../../images/lynne.pcx test_2.bmp test_2.art -PeelPlane 7
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.csv test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.ftg test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.gif test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.oko test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.pcx test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.pbm test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.ps test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.ras test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_b.ras test_2.bmp -Format "ras#SUN"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.tga test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.tif test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2a.txt test_2.bmp -Format "txt#plain"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2b.txt test_2.bmp -Format "txt#gm"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.wbmp test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.art test_2.wpg test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_2.wpg test_2.xpm test_2.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


echo "########### 16 levels gray image #############"
# Direct support: OKO, TIF, PNG, PGM
# Indirect support (gray palette): BMP, GIF

./gconvert -SeparateIDX ../../images/VGALOGO.rle test_F.oko -s


if [ $HasPNG -ge 1 ]; then
OneTest ../../images/VGALOGO.rle test_F.png test_F.oko -SeparateIDX
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
fi

OneTest ../../images/VGALOGO.rle test_F.pgm test_F.oko
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_F.oko test_F.ftg test_F.pgm
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_F.oko test_F.ras test_F.pgm
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_F.oko test_F.ras test_F.pgm -Format "ras#SUN"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_F.oko test_F.ras test_F.pgm
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_F.oko test_F.tif test_F.pgm
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

# indirect

OneTest ../../images/VGALOGO.rle test_F.bmp test_F.oko -SeparateIDX
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/VGALOGO.rle test_F.gif test_F.oko -SeparateIDX
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


echo "########### 256 levels gray image #############"

OneTest ../../images/lynne.pcx test_.bmp ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/lynne.pcx test_.csv ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/lynne.pcx test_.ftg ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/lynne.pcx test_.fts ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/lynne.pcx test_.gif ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/lynne.pcx test_.mat ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/lynne.pcx test_.oko ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_.mat test_.pcx ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_.mat test_.pgm ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

if [ $HasPNG -ge 1 ]; then
OneTest test_.mat test_.png ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
fi

OneTest test_.mat test_.ps ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_.mat test_b.ras ../../images/lynne.pcx -Format "ras#SUN"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_.mat test_.ras ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_.mat test_.sgi ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_.mat test_.tga ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_.mat test_.tif ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_.mat test_a.txt ../../images/lynne.pcx -Format "txt#plain"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_.mat test_b.txt ../../images/lynne.pcx -Format "txt#gm"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_.mat test_.xpm ../../images/lynne.pcx
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


echo "########### 65536 levels gray image #############"

OneTest ../../images/lenaI16.mat test_3.bmp ../../images/lenaI16.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/lenaI16.mat test_3.csv ../../images/lenaI16.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/lenaI16.mat test_3.ftg ../../images/lenaI16.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


OneTest ../../images/lenaI16.mat test_3.fts ../../images/lenaI16.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


OneTest test_3.fts test_3.mat ../../images/lenaI16.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_3.fts test_3.oko ../../images/lenaI16.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_3.fts test_3.pgm ../../images/lenaI16.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

if [ $HasPNG -ge 1 ]; then
OneTest test_3.fts test_3.png ../../images/lenaI16.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
fi

OneTest test_3.fts test_3.tif ../../images/lenaI16.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_3.fts test_3a.txt ../../images/lenaI16.mat -Format "txt#plain"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_3.fts test_3b.txt ../../images/lenaI16.mat -Format "txt#gm"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_3.fts test_3.xpm ../../images/lenaI16.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


echo "########### RGB 16 bit color image #############"

OneTest ../../images/input_16.tga test_8.bmp ../../images/input_16.tga
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_8.bmp test_8.tga ../../images/input_16.tga
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_8.bmp test_8.tif ../../images/input_16.tga
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


echo "########### RGB 24 bit color image #############"

OneTest ../../images/i24.bmp test_4.bmp ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4.bmp test_4.dib ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4.bmp test_4.ftg ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4.bmp test_4.mat ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4.mat test_4.qoi ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4.mat test_4.pcx ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4.pcx test_4.eps ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

#convert test_4.bmp test_4.fts -s
#@if errorlevel 1 goto errorc
#gcomp test_4.bmp test_4.fts -s
#@if errorlevel 1 goto error

if [ $HasPNG -ge 1 ]; then
OneTest test_4.pcx test_4.png ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
fi

OneTest test_4.pcx test_4.ppm ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4.pcx test_4a.ras ../../images/i24.bmp -Format "ras#topoL"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4.pcx test_4b.ras ../../images/i24.bmp -Format "ras#SUN"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4b.ras test_4.sgi ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4b.ras test_4.tga ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4b.ras test_4.tif ../../images/i24.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_4.tga test_4.txt ../../images/i24.bmp -Format "txt#gm"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


#-------------- Fuzzy ----------------

if [ $HasJPG -ge 1 ]; then
OneTest test_4.pcx test_4b.jpg ../../images/i24.bmp "" "" "-Fuzzy"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
fi


if [ $HasWEBP -ge 1 ]; then
OneTest test_4.pcx test_4b.webp ../../images/i24.bmp "" "" "-Fuzzy"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
fi


echo "########### ARGB 32 bit color image #############"

OneTest ../../images/gracehop.bmp test_Z.aai ../../images/gracehop.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/gracehop.bmp test_Z.dib test_Z.aai
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/gracehop.bmp test_Z.avs test_Z.aai
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/gracehop.bmp test_Z.bmp ../../images/gracehop.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/gracehop.bmp test_Z.qoi ../../images/gracehop.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/gracehop.bmp test_Z.pcx ../../images/gracehop.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

if [ $HasPNG -ge 1 ]; then
OneTest test_Z.pcx test_Z.png ../../images/gracehop.bmp -Format
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi
fi

OneTest ../../images/gracehop.bmp test_Z.sgi ../../images/gracehop.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/gracehop.bmp test_Z.tif ../../images/gracehop.bmp
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_Z.pcx test_Z.txt ../../images/gracehop.bmp -Format "txt#gm"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


echo "############# Floats ###################"

OneTest ../../images/floatmsb.fts test_Y.csv ../../images/floatmsb.fts
#retVal=$?
#if [ $retVal -ne 0 ]; then
#    return $retVal
#fi

OneTest ../../images/floatmsb.fts test_Y.fts ../../images/floatmsb.fts
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/floatmsb.fts test_Y.mat ../../images/floatmsb.fts
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


#-------------- Indirect ----------------

OneTest ../../images/floatmsb.fts test_Y.txt ../../images/floatmsb.fts -Format txt#plain
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi



echo "############# Doubles ###################"
# Real value named "double" is supported with formats FTS and MAT
# Formats CSV and TXT(plain) can also store double with lower precision.

OneTest ../../images/double.mat test_5.csv ../../images/double.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/double.mat test_5.fts ../../images/double.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_5.fts test_5.mat ../../images/double.mat
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_5.fts test_5.txt ../../images/double.mat -Format "txt#plain"
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


echo "############# Multiple frames ###################"

OneTest ../../images/HEX_Cnt.gif test_9.bmp ../../images/HEX_Cnt.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/HEX_Cnt.gif test_9.ftg ../../images/HEX_Cnt.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest ../../images/HEX_Cnt.gif test_9.gif ../../images/HEX_Cnt.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

#@rem Gray only
#@rem convert ../../images/HEX_Cnt.gif test_9.mat -s
#@rem @if errorlevel 1 goto errorc
#@rem gcomp test_9.bmp test_9.mat -s
#@rem @if errorlevel 1 goto error

OneTest test_9.gif test_9.tif ../../images/HEX_Cnt.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi

OneTest test_9.gif test_9.tga ../../images/HEX_Cnt.gif
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


OneTest test_9.gif test_9.txt ../../images/HEX_Cnt.gif -format txt#gm
retVal=$?
if [ $retVal -ne 0 ]; then
    return $retVal
fi


return 0
}


if test -d bin/generic ; then
  #echo "Didectory exists."
  cd bin/generic
  pwd
  MakeTests
  retVal=$?
  #echo $retVal
  case $retVal in
    0) rm test_*.*
       if test -f core ; then
         rm core
       fi
       echo "############# END OF TESTS ###################";;
    1) echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
       echo "Convert of image has been failed"
       echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";;
    2) echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
       echo " Image compare has been failed"
       echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";;
    *) echo "Unknown return code";;
  esac

  pwd
  cd ../../
fi



#echo off
echo "###############################################"

